Rem
Rem $Header: create_queues.sql 11-jul-2003.15:48:25 kbittler Exp $
Rem
Rem create_queues.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      create_queues.sql - Create queues needed for this sample.
Rem
Rem    DESCRIPTION
Rem      This script assumes that create_users.sql has already been run.
Rem      It creates one queue and one topic with payload of type
Rem      SYS.AQ$_JMS_TEXT_MESSAGE:
Rem         JMS_TEXTQ, JMS_TEXTT.
Rem
Rem    NOTES
Rem

connect mgwuser/mgwuser
set serveroutput on

-- create queue tables, queues, and topics
begin
    dbms_aqadm.create_queue_table(
                   queue_table => 'jms_text_t',
                   queue_payload_type => 'sys.aq$_jms_text_message',
                   multiple_consumers => FALSE);

    dbms_aqadm.create_queue(queue_name =>'jms_textq',
                            queue_table => 'jms_text_t',
                            max_retries => 1000);

    dbms_aqadm.start_queue('jms_textq');

    dbms_aqadm.create_queue_table(
                   queue_table => 'jms_textt_t',
                   queue_payload_type => 'sys.aq$_jms_text_message',
                   multiple_consumers => TRUE);

    dbms_aqadm.create_queue(queue_name =>'jms_textt',
                            queue_table => 'jms_textt_t');

    dbms_aqadm.start_queue('jms_textt');
end;
/

